// MyTrayDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MyTray.h"
#include "MyTrayDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


void SecondsToStrings(long seconds, CString& hh, CString& mm, CString& ss)
{
   char c[32];

   long h, m, s;
   
   h = (seconds                           ) / (60 * 60);
   m = (seconds - (h * 60 * 60)           ) / (60     );
   s = (seconds - (h * 60 * 60) - (m * 60)) / (1      );


   sprintf(c, "%0.2d", h);
   hh = c;
   sprintf(c, "%0.2d", m);
   mm = c;
   sprintf(c, "%0.2d", s);
   ss = c;
}

long HMSToSeconds(long h, long m, long s)
{
   return (h * 60 * 60 + m * 60 + s);
}

long StringsToSeconds(const char* hh, const char* mm, const char* ss)
{
   return (atoi(hh) * 60 + atoi(mm)) * 60 + atoi(ss);
}




/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CTrayDialog
{


public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CTrayDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CTrayDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CTrayDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyTrayDlg dialog

CMyTrayDlg::CMyTrayDlg(CWnd* pParent /*=NULL*/)
	: CTrayDialog(CMyTrayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMyTrayDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMyTrayDlg::DoDataExchange(CDataExchange* pDX)
{
	CTrayDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMyTrayDlg)
	DDX_Control(pDX, IDC_BUTTON2, m_gui_Button2);
	DDX_Control(pDX, IDC_STATIC2, m_gui_Static2);
	DDX_Control(pDX, IDC_STATIC3, m_gui_Static3);
	DDX_Control(pDX, IDC_STATIC1, m_gui_Static1);
	DDX_Control(pDX, IDC_EDIT3, m_gui_Edit3);
	DDX_Control(pDX, IDC_EDIT2, m_gui_Edit2);
	DDX_Control(pDX, IDC_EDIT1, m_gui_Edit1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMyTrayDlg, CTrayDialog)
	//{{AFX_MSG_MAP(CMyTrayDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_TRAYMENU_ITEM1, OnTraymenuItem1)
	ON_COMMAND(ID_TRAYMENU_ITEM2, OnTraymenuItem2)
	ON_COMMAND(ID_TRAYMENU_ITEM3, OnTraymenuItem3)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyTrayDlg message handlers

BOOL CMyTrayDlg::OnInitDialog()
{
	CTrayDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	TraySetIcon(IDR_MAINFRAME);
	TraySetToolTip("Programmers Break Timer");
	TraySetMenu(IDR_MENU1);
	
	// Uncomment theese lines if you don't want to minimize to tray, and
	// have the tray icon displayed all the time

	// TraySetMinimizeToTray(FALSE);
	// TrayShow();



   long period;
   period = HMSToSeconds(0, 30, 0);
   CString hh, mm, ss;

   SecondsToStrings(period, hh, mm, ss);

   m_gui_Edit1.SetWindowText(hh);
   m_gui_Edit2.SetWindowText(mm);
   m_gui_Edit3.SetWindowText(ss);

   m_InAlarm = false;
   m_Paused  = false;

   Reset();
   
   SetTimer(1, 1000, (TIMERPROC)NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMyTrayDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CTrayDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMyTrayDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CTrayDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMyTrayDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMyTrayDlg::OnTraymenuItem1() 
{
//	if(m_bMinimizeToTray)
		if(TrayHide())
			this->ShowWindow(SW_SHOW);
}

void CMyTrayDlg::OnTraymenuItem2() 
{
   PostMessage(WM_CLOSE,0,0);
}

void CMyTrayDlg::OnTraymenuItem3() 
{
	AfxMessageBox("Item 3 Clicked !");
}

void CMyTrayDlg::OnCancel() 
{
   if (IDOK == MessageBox("Really Quit?", "Programmer's Break Timer", MB_OKCANCEL))
	   CTrayDialog::OnCancel();
}

void CMyTrayDlg::OnOK() 
{
}

void CMyTrayDlg::Reset()
{
   CString hh,mm,ss;

   m_gui_Edit1.GetWindowText(hh);
   m_gui_Edit2.GetWindowText(mm);
   m_gui_Edit3.GetWindowText(ss);

   m_Period     = StringsToSeconds(hh, mm, ss);
   m_TimeTarget = time(NULL) + m_Period;
   m_PausedTogo = m_Period;

   Pulse();
}

void CMyTrayDlg::Pause()
{
   if (m_Paused) {
      m_TimeTarget = time(NULL) + m_PausedTogo;
      SetWindowPos(&wndNoTopMost, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
      SetWindowText("Break Timer");
      m_gui_Button2.SetWindowText("Pause");
      m_Paused = false;

   }
   else {
      m_PausedTogo = m_TimeTarget - time(NULL);
      SetWindowPos(&wndTopMost  , 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_SHOWWINDOW);
      SetWindowText("PAUSED - Break Timer");
      m_gui_Button2.SetWindowText("Resume");
      m_Paused = true;
   }
}


void CMyTrayDlg::Pulse()
   {
   
   long togo;
   CString hh, mm, ss;

   togo = m_TimeTarget - time(NULL);

   SecondsToStrings(togo, hh, mm, ss);

   m_gui_Static1.SetWindowText(hh);
   m_gui_Static2.SetWindowText(mm);
   m_gui_Static3.SetWindowText(ss);

   if (TrayIsVisible())
      {
      char s[128];
      sprintf (s, "Break:%0.2s:%0.2s:%0.2s", hh, mm, ss);
	   TraySetToolTip(s);
      TrayUpdate();
      }

   if (togo < 0 && !m_InAlarm)
      {
      Alarm(togo);
      }

   }

void CMyTrayDlg::Alarm(long togo)
   {
   HWND active;
   
   active = ::GetForegroundWindow();

   m_InAlarm = true;
   MessageBox("Take A Break!!", "Programmer's Break Timer", MB_OK | MB_TOPMOST | MB_SETFOREGROUND);
   m_InAlarm = false;
   Reset();

   if (active)
      ::SetForegroundWindow(active);
   
	}




void CMyTrayDlg::OnTimer(UINT nIDEvent) 
{
   if (nIDEvent != 1)
      {
      CTrayDialog::OnTimer(nIDEvent);
      return;
      }

   if (!m_Paused)
      Pulse();
}

void CAboutDlg::OnOK() 
{
	CTrayDialog::OnOK();
}

void CMyTrayDlg::OnButton1() 
{
	Reset();
}

void CMyTrayDlg::OnButton2() 
{
	Pause();
}
